package view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.util.Observable;
import java.util.Observer;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import model.LogPanelData;
import model.ProxyEvent;
import utils.Orderer;

public class LogPanel extends JPanel implements Observer {

	private static final long serialVersionUID = 1L;
	private ProxyEvent event;
	JTextArea area2 = new JTextArea();
	private Orderer orderer = new Orderer();
	private LogPanelData logdata;

	public LogPanel(ProxyEvent event) {
		this.event = event;
		event.addObserver(this);

		this.logdata = new LogPanelData(event);

		setLayout(new BorderLayout());

		area2.setEditable(false);
		area2.setBackground(Color.WHITE);

		add(area2, BorderLayout.CENTER);
		JScrollPane scrollPane = new JScrollPane(area2);
		add(scrollPane);
	}

	@Override
	public void update(Observable o, Object arg) {

		orderer.setEvent(event);
		orderer.sortEvents();

		area2.setText(logdata.genText());

	}
}
